from bpy.types import Operator, Context, Collection
from ...addon.naming import FluidLabNaming
from ...libs.functions.get_common_vars import get_common_vars
from ...libs.functions.collections import set_active_collection_to_master_coll, create_new_collection, set_active_collection_by_name


class FLUIDLAB_OT_fluid_forces_add_base_class(Operator):
    bl_idname = "fluidlab.fluid_forces_add_base_class"
    bl_label = "Base Class Add New Group/Force"
    bl_description = "Base Class Add Group/Force"
    bl_options = {"REGISTER", "UNDO"}

    def create_fluidlab_main_coll_if_not_exit(self, context:Context) -> None:
        # Si no existe se crea y se deja activa FluidLab:
        set_active_collection_to_master_coll(context)
    
    def create_forces_main_coll_if_not_exit(self, context:Context) -> Collection:

        self.create_fluidlab_main_coll_if_not_exit(context)
        
        fluidlab = get_common_vars(context, get_fluidlab=True)

        # Intermediate collection FL_Forces:
        fluidlab.root_collection.children_recursive
        inter_coll = next((coll for coll in fluidlab.root_collection.children_recursive if coll.name == FluidLabNaming.MAIN_FORCES_COLL), None)
        if not inter_coll:
            inter_coll = create_new_collection(context, FluidLabNaming.MAIN_FORCES_COLL)
        
        # Marcamos la collection como de tipo FluidLab_coll (para poder filtralas mejor):
        inter_coll[FluidLabNaming.FluidLab] = True
        set_active_collection_by_name(context, inter_coll.name)
        
        return inter_coll